-- events for main menu

timer = 0
function OnLoad ()
	SetProperty ("/TalismanCompleted:enter_trans_duration", 0.3);
	SetProperty ("/TalismanCompleted:leave_trans_duration", 0.3);
	CacheSound ("ui/sfx/panel_move.ogg");
	CacheSound ("music/amulet.ogg");
end;


function OnEnter ()

	PlaySound ("ui/sfx/panel_move.ogg");
	PlaySound ("music/amulet.ogg");
	
	SetProperty ("star2:blend_mode", "ADDITIVE");
	
	level_number = GetGameValue ("level_number")-1;
	talisman_num = math.floor (level_number/5);
	Print ("Unlocking talisman '" .. Azkend_GetPowerupID(talisman_num-1) .. "\n");
	SetGameValue ("powerup_unlocked_"..Azkend_GetPowerupID(talisman_num-1), true);

	if (Azkend_AutoplayerActive ()) then
		OnClick ("Ok");
	end;	
end;

function OnLeave ()

	if (GetGameValue ("level_number") == 41) then
		PushScreen ("StoryAllTalismansFound");
	end;
    
end;


function OnClick (name)

	Print ("OnClick " .. name .. "\n");
	
	if (name == "Ok") then
	    	PlaySound ("ui/sfx/panel_move.ogg");
	    	
	    	level_number = GetGameValue ("level_number");
	    	
				if (Azkend_NoPowerupsSelected ()) then
					Azkend_SelectPowerup ("Amulet_" .. Azkend_GetPowerupID (talisman_num-1));
				end;
	    	
	    	
	    	talismans_received = math.floor (level_number/5);
	    	
				lev_num_completed = GetGameValue ("level_number")-1;
				if (math.floor (math.fmod (lev_num_completed, 7)) == 0) then
					episode = math.floor (lev_num_completed / 7);
					Print ("Episode number is "..episode.."\n");
					SwitchScreen ("HiddenWorld");--..episode);
				else
					if (level_number < 2 * 5) then
						SwitchScreen ("WorldMap");
					else
						PopScreen ();
					end;
				end;
	    	

--	    	if (talismans_received > 3) then
--	    		SwitchScreen ("Shaman");
--	    	else
--	    		SwitchScreen ("WorldMap");
--	    	end;

		return;
	end;

end;


function OnUpdate (tdelta)

	akey = GetActiveScreenAnimKey ();

	timer = timer+tdelta;
	
	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
	SetProperty ("panel:position_offset.y", (1-trans) * 200);
	SetProperty ("panel:alpha", trans);
	SetProperty ("fader:alpha", trans + trans * 0.05 * math.sin (2*3.141592*akey));
	
	SetProperty ("star2:angle", math.sin(timer));
    SetProperty ("star2:alpha", GetActiveScreenTransPhase()*0.8);

end;

function OnDraw ()

end;
